/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.websm.lpar.LPARInfo;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class DLPAR {
    public static final int MANAGED_SYSTEM = 0;
    public static final int SOURCE_PARTITION = 1;
    public static final int TARGET_PARTITION = 2;
    public static final int OPERATION_TYPE = 3;
    public static final int RESOURCE_TYPE = 4;
    public static final int QUANTITY = 5;
    public static final int ID = 6;
    public static final int SLOT = 7;
    public static final int TIMEOUT = 8;
    public static final int DETAIL_LEVEL = 9;
    private UnsignedInt8 _detailLevel = null;
    private Integer _timeout = null;
    private String _DRCName = null;
    private String _resourceType = null;
    private String _operationType = null;
    private String _targetPartition = null;
    private String _sourcePartition = null;
    private String _managedSystem = null;
    private Integer _quantity = null;
    private Integer _slot = null;
    private String _id = null;

    public DLPAR() {
        IDebug.Setup();
    }

    public short validateArguments(String[] stringArray) {
        if (stringArray.length < 8) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "MISSING_ARGUMENTS", "Not enough arguments specified."));
            return 1;
        }
        this._managedSystem = stringArray[0].substring(stringArray[0].indexOf(34) + 1, stringArray[0].lastIndexOf(34));
        this._sourcePartition = stringArray[1].substring(stringArray[1].indexOf(34) + 1, stringArray[1].lastIndexOf(34));
        if (!stringArray[2].equals("NONE")) {
            this._targetPartition = stringArray[2].substring(stringArray[2].indexOf(34) + 1, stringArray[2].lastIndexOf(34));
        }
        this._resourceType = stringArray[4];
        try {
            Integer n = Integer.valueOf(stringArray[9]);
            if (n < 0 || n > 5) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_DETAIL_LEVEL", "Invalid detail level value."));
                return 1;
            }
            this._detailLevel = new UnsignedInt8(n.shortValue());
        }
        catch (Throwable throwable) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_DETAIL_LEVEL", "Invalid detail level value."));
            DLPAR._printException(throwable);
            return 1;
        }
        try {
            this._timeout = Integer.valueOf(stringArray[8]);
        }
        catch (Throwable throwable) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_TIMEOUT_ARGUMENT_SPECIFIED", "Invalid quantity timeout specified."));
            DLPAR._printException(throwable);
            return 1;
        }
        try {
            this._quantity = Integer.valueOf(stringArray[5]);
        }
        catch (Throwable throwable) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_QUANTITY_ARGUMENT_SPECIFIED", "Invalid quantity argument specified."));
            DLPAR._printException(throwable);
            return 1;
        }
        if (this._resourceType.equals("slot")) {
            this._id = stringArray[6];
            try {
                this._slot = Integer.valueOf(stringArray[7]);
            }
            catch (Throwable throwable) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_SLOT_ARGUMENT_SPECIFIED", "Invalid slot id specified."));
                DLPAR._printException(throwable);
                return 1;
            }
            if (this._id.equals("-1") || this._slot == -1) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_SLOT_ARGUMENT_SPECIFIED", "Invalid slot id specified."));
                return 1;
            }
        }
        this._operationType = stringArray[3];
        if (!(this._operationType.equals("m") || this._operationType.equals("a") || this._operationType.equals("r"))) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_OPERATION_TYPE", "Invalid operation type specified"));
            return 1;
        }
        if (this._operationType.equals("m") && this._targetPartition == null) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "MISSING_REQUIRED_TARGET_ARG", "Missing required target partition."));
            return 1;
        }
        return 0;
    }

    int printDLPARCommandOutput(Hashtable hashtable) {
        Object var2_2 = null;
        int n = 0;
        if (hashtable == null) {
            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_COMMAND_FAILED", "Error in local RMC subsystem"));
            ++n;
        } else {
            var2_2 = hashtable.get("Rc");
            if (var2_2 == null || (Integer)var2_2 != 0) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_COMMAND_FAILED", "Error in local RMC subsystem"));
                ++n;
            }
            if ((var2_2 = hashtable.get("CmdRc")) == null || (Integer)var2_2 != 0) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "DRMGR_FAILED", "drmgr command failed"));
                ++n;
            }
            if (this._detailLevel != null && this._detailLevel.shortValue() > 0) {
                System.out.println(hashtable.get("CmdStdoutMsg"));
                System.err.println(hashtable.get("CmdStderrMsg"));
            }
        }
        return n;
    }

    public short doLPAR(String[] stringArray) {
        int n;
        String string;
        int n2;
        String string2;
        StringTokenizer stringTokenizer;
        CIMValue cIMValue;
        CIMProperty cIMProperty;
        Object object;
        UnsignedInt8[] unsignedInt8Array;
        UnsignedInt8[] unsignedInt8Array2;
        String[] stringArray2;
        UnsignedInt8 unsignedInt8;
        UnsignedInt8 unsignedInt82;
        Object var13_13;
        String string3;
        CIMInstance cIMInstance;
        CIMInstance cIMInstance2;
        CIMInstance cIMInstance3;
        CIMProperty cIMProperty2;
        CIMProperty cIMProperty3;
        block108: {
            CIMObjectPath cIMObjectPath = null;
            cIMProperty3 = null;
            cIMProperty2 = null;
            CIMObjectPath cIMObjectPath2 = null;
            CIMInstance cIMInstance4 = null;
            cIMInstance3 = null;
            CIMInstance cIMInstance5 = null;
            cIMInstance2 = null;
            cIMInstance = null;
            string3 = null;
            Object var12_12 = null;
            var13_13 = null;
            unsignedInt82 = null;
            unsignedInt8 = null;
            stringArray2 = new String[1];
            unsignedInt8Array2 = new UnsignedInt8[1];
            unsignedInt8Array = new UnsignedInt8[1];
            try {
                string3 = InetAddress.getLocalHost().getHostName();
                cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMObjectPath.addKey("Name", new CIMValue((Object)this._managedSystem));
                cIMInstance4 = HscUtil.getCIMInstance(string3, cIMObjectPath, false);
                if (cIMInstance4 != null && (object = HscUtil.getCIMAssociation(string3, cIMObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", "GroupComponent", "PartComponent")) != null) {
                    while (object.hasMoreElements()) {
                        cIMProperty = (CIMObjectPath)object.nextElement();
                        cIMInstance5 = HscUtil.getCIMInstance(string3, (CIMObjectPath)cIMProperty, false);
                        if (cIMInstance5 == null) continue;
                        cIMValue = null;
                        stringTokenizer = cIMInstance5.getProperty("UserDefinedName");
                        if (stringTokenizer == null) continue;
                        cIMValue = stringTokenizer.getValue();
                        if (cIMValue != null && this._sourcePartition.equals(cIMValue.getValue())) {
                            cIMInstance = cIMInstance5;
                            cIMProperty3 = cIMProperty;
                        }
                        if (cIMValue == null || this._targetPartition == null || !this._targetPartition.equals(cIMValue.getValue())) continue;
                        cIMInstance2 = cIMInstance5;
                        cIMProperty2 = cIMProperty;
                    }
                }
            }
            catch (Throwable throwable) {
                if (cIMInstance4 == null) {
                    System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_MANAGED_SYSTEM"), this._managedSystem));
                    return 1;
                }
                DLPAR._printException(throwable);
                return 1;
            }
            if (this._resourceType.equals("slot")) {
                try {
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                    cIMObjectPath2.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMObjectPath2.addKey("IODrawerSystemName", new CIMValue((Object)this._managedSystem));
                    cIMObjectPath2.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                    cIMObjectPath2.addKey("IODrawerDeviceID", new CIMValue((Object)this._id));
                    cIMObjectPath2.addKey("SlotID", new CIMValue((Object)new UnsignedInt8(this._slot.shortValue())));
                    cIMInstance3 = HscUtil.getCIMInstance(string3, cIMObjectPath2, false);
                    if (cIMInstance3 == null) break block108;
                    boolean bl = false;
                    try {
                        bl = DLPAR._slotAssigned(string3, (CIMObjectPath)cIMProperty3, cIMInstance3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this._operationType.equals("r") || this._operationType.equals("m")) {
                        if (!bl) {
                            System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "UNALLOCATED_SLOT"));
                            return 1;
                        }
                    } else if (this._operationType.equals("a") && bl) {
                        return 0;
                    }
                    if ((cIMProperty = cIMInstance3.getProperty("SlotLocation")) != null) {
                        cIMValue = cIMProperty.getValue();
                        this._DRCName = (String)cIMValue.getValue();
                    }
                    stringArray2[0] = new String(this._id);
                    unsignedInt8Array2[0] = new UnsignedInt8(this._slot.shortValue());
                    cIMValue = cIMInstance3.getProperty("PCIBus");
                    if (cIMValue != null) {
                        unsignedInt8Array[0] = (UnsignedInt8)cIMValue.getValue().getValue();
                    }
                }
                catch (Throwable throwable) {
                    DLPAR._printException(throwable);
                    return 1;
                }
            }
        }
        object = null;
        if (cIMInstance != null) {
            short s;
            cIMProperty = cIMInstance.getProperty("Name");
            if (cIMProperty != null && (stringTokenizer = new StringTokenizer((String)(object = (String)(cIMValue = cIMProperty.getValue()).getValue()), "*")).countTokens() > 0) {
                try {
                    string2 = stringTokenizer.nextToken();
                    n2 = Short.parseShort(string2);
                    unsignedInt82 = new UnsignedInt8((short)n2);
                }
                catch (Throwable throwable) {
                    DLPAR._printException(throwable);
                    return 1;
                }
            }
            if ((cIMProperty = cIMInstance.getProperty("DLPARCapabilities")) != null) {
                cIMValue = cIMProperty.getValue();
                stringTokenizer = (UnsignedInt32)cIMValue.getValue();
                if (stringTokenizer != null && stringTokenizer.longValue() != 15L || stringTokenizer == null) {
                    System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_DLPAR_CAPABILITY"), this._sourcePartition));
                    return 1;
                }
            } else {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_DLPAR_CAPABILITY"), this._sourcePartition));
                return 1;
            }
            cIMProperty = cIMInstance.getProperty("State");
            if (cIMProperty != null && (s = ((Number)(cIMValue = cIMProperty.getValue()).getValue()).shortValue()) != 8) {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_LPAR_STATE"), this._sourcePartition));
                return 1;
            }
        } else {
            System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_PARTITION_NAME"), this._sourcePartition));
            return 1;
        }
        cIMProperty = DLPAR._getActivatedProfileInst(string3, cIMProperty3);
        if (cIMProperty != null) {
            int n3 = DLPAR._getAllocatedCPU(string3, (CIMObjectPath)cIMProperty3);
            String string4 = null;
            string4 = this._operationType.equals("m") ? new String("r") : this._operationType;
            if (this._resourceType.equals("cpu") && !DLPAR._validRequest((CIMInstance)cIMProperty, string4, this._resourceType, this._quantity, n3, null, null)) {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "CPU_REQUIREMENT_NOT_MET"), this._sourcePartition));
                return 1;
            }
            if (this._resourceType.equals("slot") && !DLPAR._validRequest((CIMInstance)cIMProperty, string4, this._resourceType, null, 0, this._id, this._slot)) {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "UNABLE_TO_FREE_SLOT"), this._sourcePartition));
                return 1;
            }
        }
        if (cIMInstance2 != null) {
            short s;
            CIMValue cIMValue2;
            CIMProperty cIMProperty4;
            if (IDebug.enabled) {
                System.out.println("found partition instance " + cIMInstance2);
            }
            if ((cIMProperty4 = cIMInstance2.getProperty("Name")) != null) {
                CIMValue cIMValue3 = cIMProperty4.getValue();
                string2 = (String)cIMValue3.getValue();
                if (this._operationType.equals("m") && string2.equals(object)) {
                    return 0;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "*");
                if (stringTokenizer2.countTokens() > 0) {
                    try {
                        string = stringTokenizer2.nextToken();
                        n = Short.parseShort(string);
                        unsignedInt8 = new UnsignedInt8((short)n);
                    }
                    catch (Throwable throwable) {
                        DLPAR._printException(throwable);
                        return 1;
                    }
                }
            }
            if ((cIMProperty4 = cIMInstance2.getProperty("DLPARCapabilities")) != null) {
                cIMValue2 = cIMProperty4.getValue();
                string2 = (UnsignedInt32)cIMValue2.getValue();
                if (string2 != null && string2.longValue() != 15L || string2 == null) {
                    System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_DLPAR_CAPABILITY"), this._targetPartition));
                    return 1;
                }
            } else {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_DLPAR_CAPABILITY"), this._targetPartition));
                return 1;
            }
            cIMProperty4 = cIMInstance2.getProperty("State");
            if (cIMProperty4 != null && (s = ((Number)(cIMValue2 = cIMProperty4.getValue()).getValue()).shortValue()) != 8) {
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_LPAR_STATE"), this._targetPartition));
                return 1;
            }
            cIMValue2 = DLPAR._getActivatedProfileInst(string3, (CIMObjectPath)cIMProperty2);
            if (cIMValue2 != null) {
                int n4 = DLPAR._getAllocatedCPU(string3, (CIMObjectPath)cIMProperty2);
                String string5 = null;
                string5 = this._operationType.equals("m") ? new String("a") : this._operationType;
                if (this._resourceType.equals("cpu") && !DLPAR._validRequest((CIMInstance)cIMValue2, string5, this._resourceType, this._quantity, n4, null, null)) {
                    System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "CPU_REQUIREMENT_NOT_MET"), this._targetPartition));
                    return 1;
                }
            }
        } else if (!this._targetPartition.equals("NONE")) {
            System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_PARTITION_NAME"), this._targetPartition));
            return 1;
        }
        Boolean bl = new Boolean(this._operationType.equals("a"));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        if (this._operationType.equals("r")) {
            vector.addElement(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt8(0))));
        } else {
            vector.addElement(new CIMProperty("DestinationSlotID", new CIMValue((Object)unsignedInt82)));
        }
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        n2 = 0;
        if (this._quantity != null) {
            n2 = this._quantity;
        }
        if (this._resourceType.equals("cpu")) {
            vector2.addElement(new CIMProperty("CPUSuccesses", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))));
            int n5 = 0;
            if (!bl.booleanValue()) {
                n = 0;
                while (n < n2) {
                    try {
                        Hashtable hashtable = LPARInfo.doDLPARCommand(cIMInstance, this._resourceType, bl, this._DRCName, this._timeout, this._detailLevel);
                        if (this.printDLPARCommandOutput(hashtable) != 0) break;
                        ++n5;
                    }
                    catch (Throwable throwable) {
                        DLPAR._printException(throwable);
                    }
                    ++n;
                }
            }
            if (n5 == 0 && !bl.booleanValue()) {
                return 1;
            }
            try {
                if (!bl.booleanValue()) {
                    if (IDebug.enabled()) {
                        System.out.println("total cpu removed from partition " + this._sourcePartition + " " + n5);
                    }
                    if (n5 > 0) {
                        if (this._operationType.equals("m")) {
                            vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)unsignedInt8)), 0);
                        }
                        vector.addElement(new CIMProperty("CPUQuantity", new CIMValue((Object)new UnsignedInt8((short)n5))));
                        CIMValue cIMValue4 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "CPULPARTask", vector, vector2);
                    }
                } else {
                    vector.addElement(new CIMProperty("CPUQuantity", new CIMValue((Object)new UnsignedInt8((short)n2))));
                    CIMValue cIMValue5 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "CPULPARTask", vector, vector2);
                }
            }
            catch (Throwable throwable) {
                DLPAR._printException(throwable);
                return 1;
            }
            if (this._operationType.equals("m") || this._operationType.equals("a")) {
                int n6;
                UnsignedInt8 unsignedInt83 = (UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                int n7 = n6 = unsignedInt83 != null ? unsignedInt83.intValue() : var13_13.intValue();
                if (n6 == 0) {
                    System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "UNABLE_TO_FREE_PROCESSOR", "There are currently no more free processors to perform the request"));
                    return 1;
                }
                CIMInstance cIMInstance6 = null;
                cIMInstance6 = bl != false ? cIMInstance : cIMInstance2;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n6) {
                    block109: {
                        try {
                            Hashtable hashtable = LPARInfo.doDLPARCommand(cIMInstance6, this._resourceType, new Boolean(true), this._DRCName, this._timeout, this._detailLevel);
                            if (this.printDLPARCommandOutput(hashtable) == 0) {
                                ++n8;
                                break block109;
                            }
                            if (IDebug.enabled()) {
                                System.out.println("Failed perform cmd on PARTITION.");
                            }
                            vector.setElementAt(new CIMProperty("CPUQuantity", new CIMValue((Object)new UnsignedInt8((short)(this._quantity.shortValue() - n8)))), 1);
                            vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt8(0))), 0);
                            if (this._operationType.equals("a")) {
                                CIMValue cIMValue6 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "CPULPARTask", vector, new Vector());
                            } else if (this._operationType.equals("m")) {
                                CIMValue cIMValue7 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty2, "CPULPARTask", vector, new Vector());
                            }
                            return 1;
                        }
                        catch (Throwable throwable) {
                            DLPAR._printException(throwable);
                            return 1;
                        }
                    }
                    ++n9;
                }
            }
        } else if (this._resourceType.equals("mem")) {
            vector.addElement(new CIMProperty("LMBQuantity", new CIMValue((Object)new UnsignedInt8(this._quantity.shortValue()))));
            try {
                if (IDebug.enabled()) {
                    System.out.println("Invoking MemLPARTask with inParams set to " + vector.elementAt(0) + " and " + vector.elementAt(1));
                }
                if (this._operationType.equals("m")) {
                    vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)unsignedInt8)), 0);
                } else if (this._operationType.equals("r")) {
                    vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt8(0))), 0);
                }
                string = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "MemLPARTask", vector, new Vector());
            }
            catch (Throwable throwable) {
                DLPAR._printException(throwable);
                return 1;
            }
            if (this._operationType.equals("m") || this._operationType.equals("r")) {
                int n10 = 0;
                n = 0;
                while (n < this._quantity) {
                    block110: {
                        try {
                            Hashtable hashtable = LPARInfo.doDLPARCommand(cIMInstance, this._resourceType, new Boolean(false), this._DRCName, this._timeout, this._detailLevel);
                            if (this.printDLPARCommandOutput(hashtable) == 0) {
                                ++n10;
                                break block110;
                            }
                            vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)unsignedInt82)), 0);
                            vector.setElementAt(new CIMProperty("LMBQuantity", new CIMValue((Object)new UnsignedInt8((short)(this._quantity.shortValue() - n10)))), 1);
                            CIMValue cIMValue8 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "MemLPARTask", vector, new Vector());
                            return 1;
                        }
                        catch (Throwable throwable) {
                            DLPAR._printException(throwable);
                            return 1;
                        }
                    }
                    ++n;
                }
            }
            if (this._operationType.equals("a") || this._operationType.equals("m")) {
                CIMInstance cIMInstance7 = null;
                cIMInstance7 = bl != false ? cIMInstance : cIMInstance2;
                n = 0;
                int n11 = 0;
                while (n11 < this._quantity) {
                    block111: {
                        try {
                            Hashtable hashtable = LPARInfo.doDLPARCommand(cIMInstance7, this._resourceType, new Boolean(true), this._DRCName, this._timeout, this._detailLevel);
                            if (this.printDLPARCommandOutput(hashtable) == 0) {
                                ++n;
                                break block111;
                            }
                            vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt8(0))), 0);
                            vector.setElementAt(new CIMProperty("LMBQuantity", new CIMValue((Object)new UnsignedInt8((short)(this._quantity.shortValue() - n)))), 1);
                            if (this._operationType.equals("a")) {
                                CIMValue cIMValue9 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "MemLPARTask", vector, new Vector());
                            } else if (this._operationType.equals("m")) {
                                CIMValue cIMValue10 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty2, "MemLPARTask", vector, new Vector());
                            }
                            return 1;
                        }
                        catch (Throwable throwable) {
                            DLPAR._printException(throwable);
                            return 1;
                        }
                    }
                    ++n11;
                }
            }
        } else if (this._resourceType.equals("slot")) {
            CIMValue cIMValue11;
            Hashtable hashtable;
            string = cIMInstance3.getProperty("State");
            CIMValue cIMValue12 = string.getValue();
            short s = ((Number)cIMValue12.getValue()).shortValue();
            if (!bl.booleanValue()) {
                try {
                    hashtable = LPARInfo.doDLPARCommand(cIMInstance, this._resourceType, bl, this._DRCName, this._timeout, this._detailLevel);
                    if (this.printDLPARCommandOutput(hashtable) != 0) {
                        return 1;
                    }
                }
                catch (Throwable throwable) {
                    DLPAR._printException(throwable);
                    return 1;
                }
            }
            hashtable = null;
            if (this._operationType.equals("m")) {
                vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)unsignedInt8)), 0);
            }
            vector.addElement(new CIMProperty("DrawerID", new CIMValue((Object)stringArray2, new CIMDataType(29))));
            vector.addElement(new CIMProperty("SlotID", new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))));
            vector.addElement(new CIMProperty("PCIBus", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
            vector2.addElement(new CIMProperty("IOResults", new CIMValue((Object)hashtable, new CIMDataType(21))));
            try {
                if (IDebug.enabled()) {
                    System.out.println("Invoking IOLPARTask with inParams set to " + vector.elementAt(0) + " and " + vector.elementAt(1) + " and " + vector.elementAt(2) + " and " + vector.elementAt(3));
                    System.out.println("Invoking IOLPARTAsk with outParams set to " + vector2.elementAt(0));
                }
                cIMValue11 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "IOLPARTask", vector, vector2);
            }
            catch (Throwable throwable) {
                DLPAR._printException(throwable);
                return 1;
            }
            if (this._operationType.equals("m") || this._operationType.equals("a")) {
                cIMValue11 = null;
                cIMValue11 = bl != false ? cIMInstance : cIMInstance2;
                try {
                    Hashtable hashtable2 = LPARInfo.doDLPARCommand((CIMInstance)cIMValue11, this._resourceType, new Boolean(true), this._DRCName, this._timeout, this._detailLevel);
                    if (this.printDLPARCommandOutput(hashtable2) != 0) {
                        vector.setElementAt(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt8(0))), 0);
                        if (this._operationType.equals("a")) {
                            CIMValue cIMValue13 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty3, "IOLPARTask", vector, vector2);
                        } else if (this._operationType.equals("m")) {
                            CIMValue cIMValue14 = HscUtil.invokeCIMMethod(string3, (CIMObjectPath)cIMProperty2, "IOLPARTask", vector, vector2);
                        }
                        return 1;
                    }
                }
                catch (Throwable throwable) {
                    DLPAR._printException(throwable);
                    return 1;
                }
            }
        }
        return 0;
    }

    private static void _printException(Throwable throwable) {
        if (IDebug.enabled()) {
            System.out.println("in printException, t = " + throwable);
            throwable.printStackTrace();
        }
        System.err.println(HSCLogUtils.getErrMsg(throwable));
    }

    private static boolean _doCmdSuccess(Hashtable hashtable) {
        boolean bl = false;
        boolean bl2 = false;
        if (hashtable == null) {
            return false;
        }
        Integer n = (Integer)hashtable.get("Rc");
        if (n != null) {
            if (n != 0) {
                return false;
            }
            bl = true;
        }
        if ((n = (Integer)hashtable.get("CmdRc")) != null) {
            if (n != 0) {
                return false;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    private static boolean _slotAssigned(String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws Throwable {
        Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, "IBMHSC_AllocatedSlot", "IBMHSC_PCISlot", "GroupComponent", "PartComponent", true, false, null);
        String string2 = (String)cIMInstance.getProperty("IODrawerDeviceID").getValue().getValue();
        String string3 = (String)cIMInstance.getProperty("IODrawerSystemName").getValue().getValue();
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("SlotID").getValue().getValue();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance2 = (CIMInstance)enumeration.nextElement();
                String string4 = (String)cIMInstance2.getProperty("IODrawerDeviceID").getValue().getValue();
                String string5 = (String)cIMInstance2.getProperty("IODrawerSystemName").getValue().getValue();
                UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMInstance2.getProperty("SlotID").getValue().getValue();
                if (!string2.equals(string4) || !string3.equals(string5) || unsignedInt8.shortValue() != unsignedInt82.shortValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static int _getAllocatedCPU(String string, CIMObjectPath cIMObjectPath) {
        int n;
        block3: {
            n = 0;
            try {
                Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, "IBMHSC_AllocatedProcessor", "CIM_Processor", "GroupComponent", "PartComponent", true, false, null);
                if (enumeration == null) break block3;
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    ++n;
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) break block3;
                throwable.printStackTrace();
            }
        }
        return n;
    }

    private static boolean _validRequest(CIMInstance cIMInstance, String string, String string2, Integer n, int n2, String string3, Integer n3) {
        UnsignedInt8 unsignedInt8;
        Object object;
        Vector vector;
        Vector vector2;
        Vector vector3;
        int n4;
        short s;
        block14: {
            s = 0;
            n4 = 0;
            vector3 = null;
            vector2 = null;
            vector = null;
            try {
                CIMValue cIMValue = null;
                object = cIMInstance.getProperty("MinimumCPUCount");
                if (object != null && (cIMValue = object.getValue()) != null && (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) != null) {
                    s = unsignedInt8.shortValue();
                }
                if ((object = cIMInstance.getProperty("MaximumCPUCount")) != null && (cIMValue = object.getValue()) != null && (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) != null) {
                    n4 = unsignedInt8.shortValue();
                }
                if ((object = cIMInstance.getProperty("IODrawer")) != null && (cIMValue = object.getValue()) != null) {
                    vector3 = (Vector)cIMValue.getValue();
                }
                if ((object = cIMInstance.getProperty("IOSlots")) != null && (cIMValue = object.getValue()) != null) {
                    vector2 = (Vector)cIMValue.getValue();
                }
                if ((object = cIMInstance.getProperty("IORequirement")) != null && (cIMValue = object.getValue()) != null) {
                    vector = (Vector)cIMValue.getValue();
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) break block14;
                throwable.printStackTrace();
            }
        }
        if (string2.equals("cpu")) {
            int n5;
            int n6 = n5 = n != null ? n : 0;
            if (string.equals("r")) {
                return n2 - n5 >= s;
            }
            if (string.equals("a")) {
                return n2 + n5 <= n4;
            }
        } else if (string2.equals("slot") && string.equals("r") && n3 != null && string3 != null && vector3 != null && vector != null && vector2 != null) {
            int n7 = 0;
            while (n7 < vector3.size()) {
                String string4;
                object = (String)vector3.elementAt(n7);
                if (((String)object).equals(string3) && (unsignedInt8 = (UnsignedInt8)vector2.elementAt(n7)).intValue() == n3.intValue() && (string4 = (String)vector.elementAt(n7)).equals("R")) {
                    return false;
                }
                ++n7;
            }
        }
        return true;
    }

    private static CIMInstance _getActivatedProfileInst(String string, CIMObjectPath cIMObjectPath) {
        block3: {
            try {
                Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, "IBMHSC_ActivatedLparProfile", "IBMHSC_LparProfile", "Element", "Setting", false, false, null);
                if (enumeration == null) break block3;
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    if (cIMInstance == null) continue;
                    return cIMInstance;
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) break block3;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        DLPAR dLPAR = new DLPAR();
        short s = dLPAR.validateArguments(stringArray);
        if (s != 0) {
            System.exit(s);
        }
        try {
            s = dLPAR.doLPAR(stringArray);
            if (s != 0) {
                System.exit(s);
            }
        }
        catch (Throwable throwable) {
            DLPAR._printException(throwable);
            System.exit(1);
        }
        System.exit(0);
    }
}

